﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Thomas_Erdoesi.Game_Analyzer
{
    public class TimeExceededException : Exception {}
    public class GameOverException : Exception {}

    public class FramePacket
    {
        public ushort[] vectorram = new UInt16[513];
        public byte frameno;  // wird bei jedem Frame inkrementiert
        public byte ping;     // Der Server schickt das letzte empfangene ping-Byte zurück

        /// <summary>
        /// Per UDP erhaltene Bytefolge überprüfen und konvertieren
        /// </summary>
        /// <param name="array"></param>
        /// <returns></returns>
        public static FramePacket FromByteArray(byte[] array)
        {
            if (array.Length < 1026)
            {
                string Content = new ASCIIEncoding().GetString(array);

                if (Content == "busy 0\r\n")
                    throw new TimeExceededException();
                else if (Content == "game over\r\n")
                    throw new GameOverException();
                else
                    throw new Exception("Unbekanntes UDP-Paket (" + array.Length + " Bytes):\r\n" + Content);
            }

            if (array[1] != 0xe0 && array[1] != 0xe2)
                throw new Exception("Empfangenes UDP-Paket hat ungültigen Inhalt.");

            FramePacket np = new FramePacket();

            for (int i = 0; i < 513; i++)
                np.vectorram[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);

            np.frameno = array[1024];
            np.ping = array[1025];

            return np;
        }
    }
}
